ORCA/M Asm65816 2.1.0

0001 D6B2              *****************************************************************
0002 D6B2              *
0003 D6B2              * ADB main
0004 D6B2              *
0005 D6B2              * Copyright (c) Apple Computer, Inc. 1986-1988
0006 D6B2              * All Rights Reseverd
0007 D6B2              *
0008 D6B2              * Change History
0009 D6B2              *
0010 D6B2              * 03 Nov 88         Steven Glass & Joe Bo
0011 D6B2              *
0012 D6B2              * Made STool public so could call from another bank.
0013 D6B2              *
0014 D6B2              *****************************************************************
0015 D6B2
0016 D6B2                       STRING ASIS 
0017 D6B2                       BLANKS OFF 
0018 D6B2
0019 D6B2                       TITLE 'ADB Tool Sets' 
0020 D6B2
0021 D6B2
0022 D6B2              *
0023 D6B2              * The following is the SKI tool code.
0024 D6B2              * It implements calls to the Single-Chip-Microcontroller (uC) using
0025 D6B2              * the SKI protocol.
0026 D6B2              * For more information see the Single-Chip-Microcontroller (uC) ERS &
0027 D6B2              * the SKI TOOL ERS
0028 D6B2              *
0029 D6B2              * The following Flags/Variables are used:
0030 D6B2              *
0031 D6B2              * STATUSTMP: Used to save pending status data from uC. When a
0032 D6B2              * command is being sent interrupts are locked out, but
0033 D6B2              * the uC status has to be read. It is acted on at the
0034 D6B2              * end of the routine.(Status = Abort,Flush,Desktop,etc.)
0035 D6B2              *
0036 D6B2              * PENDFLG: Indicates if a command is pending. If a command is
0037 D6B2              * clr=nope Pending then it should be finished before any other
0038 D6B2              * set=pend command can be initiated. If a pending command is
0039 D6B2              * requested while this flag is set then the code
0040 D6B2              * returns w/ an error code indicating busy - try again
0041 D6B2              * later. If an immediate command is requested then
0042 D6B2              * the pending command is completed and a flag is set:
0043 D6B2              *
0044 D6B2              * RSPNSFLG: Indicates if a pending command was completed during
0045 D6B2              * clr=none a request for an immediate command. The response from
0046 D6B2              * set=pend the pending command is processed after the immediate
0047 D6B2              * command is done.
0048 D6B2              *
0049 D6B2              * RSPNSBUF: Buffer to hold response: 8 bytes for data, 1 for count
0050 D6B2              *
0051 D6B2              * The code makes extensive use of the stack and direct page. At
0052 D6B2              * the beginning of most tool functions room is made on the
0053 D6B2              * stack and then the direct page is placed on top of the stack to
0054 D6B2              * allow easy access to these variables. In most tool functions the
0055 D6B2              * stack looks like this:
0056 D6B2              *
0057 D6B2              * 26-27 Word - Input Parameter
0058 D6B2              * 22-25 Long - Input Parameter
0059 D6B2              * 20-21 Word - Input Parameter
0060 D6B2              * 1D-1F Adrs - Tool Dispatcher Return address
0061 D6B2              * 1A-1C Adrs - Calling Code Return Address
0062 D6B2              * 18-19 Word - Original Direct Page
0063 D6B2              * 17 Byte - Original Processor Status
0064 D6B2              * 16 Byte - Original Data Bank
0065 D6B2              * 14-15 Word - Variable
0066 D6B2              * A-13 10 - Response Buffer 2
0067 D6B2              * 0-09 10 - Response Buffer 1
0068 D6B2              *
0069 D6B2              *
0070 D6B2
0071 D6B2
0072 D6B2                       include '::sys.equs.asm' 
0073 D6B2
0074 D6B2              ;-------------------------------------------
0075 D6B2              ;
0076 D6B2              ; Equates form procedure ADBEQUS
0077 D6B2              ;
0078 D6B2              ;-------------------------------------------
0079 D6B2              FDBVERSION equ   $0300                  ;VERSION #
0080 D6B2              MYTOOLNUM equ   $09
0081 D6B2              TRUE     equ   $FFFF
0082 D6B2
0083 D6B2              CMDFULL  equ   $01                      ;COMMAND REG FULL BIT (IN KEYGLOO STATUS)
0084 D6B2              DATAFULL equ   $20                      ;DATA REG FULL BIT (IN KEYGLOO STATUS)
0085 D6B2              STATUSBIT equ   $80                     ;UC STATUS - RESPONSE BIT
0086 D6B2              ABORTBIT equ   $40                      ;UC STATUS - ABORT BIT
0087 D6B2              DESKBIT  equ   $20                      ;UC STATUS - DESKTOP MANAGER BIT
0088 D6B2              FLUSHBIT equ   $10                      ;UC STATUS - FLUSH BIT
0089 D6B2              IDREG    equ   $F0                      ;FDB COMMAND MASK TO READ ID REG.(3)
0090 D6B2              DISSRQ   equ   $70                      ;FDB COMMAND MASK TO DISABLE SRQ
0091 D6B2              ENSRQ    equ   $50                      ;FDB COMMAND MASK TO ENABLE SRQ
0092 D6B2              TALKCMD  equ   $C0                      ;FDB COMMAND MASK FOR TALK POLL
0093 D6B2              JMLOPCODE equ   $5C                     ;OPCODE FOR JML al INSTRUCTION
0094 D6B2              HARDERR  equ   $0010                    ;CODE FOR HARD ERROR
0095 D6B2              MAXERR   equ   $0081                    ;CODE FOR SOFT ERROR
0096 D6B2              BUSYERR  equ   $0082                    ;CODE FOR BUSY ERROR
0097 D6B2              NODEVERR equ   $0083                    ;CODE FOR NO DEVICE PRESENT ERROR
0098 D6B2              FULLERR  equ   $0084                    ;CODE FOR SRQ LIST FULL
0099 D6B2              DATABNK  equ   $00E1                    ;
0100 D6B2              *
0101 D6B2              ;-------------------------------------------
0102 D6B2              ;
0103 D6B2              ; Direct Page Addressing Modes
0104 D6B2              ;
0105 D6B2              RSPNSBUF equ   $0                       ;START AT BOTTOM OF DIRECT PAGE
0106 D6B2              RSPNSLNG equ   10                       ;BUFFER FOR PENDING COMMAND RESPONSE
0107 D6B2              PARMS    equ   RSPNSLNG*2               ;USED DURING ENDCALL
0108 D6B2              PHBOFFSET equ   PARMS+2
0109 D6B2              PHPOFFSET equ   phbOFFSET+1
0110 D6B2              PHDOFFSET equ   PHPOFFSET+1
0111 D6B2              RTLGLU   equ   phdOFFSET+2              ;GLU ROUTINE RETURN ADDRESS
0112 D6B2              RTLCALL  equ   rtlGLU+3                 ;CALLING ROUTINE RETURN ADDRESS
0113 D6B2              ZPTOS    equ   rtlCALL+3                ;OFFSET INTO STACK FOR 1ST DATA BYTE
0114 D6B2              UCCMD    equ   ZPTOS                    ;COMMAND TO uC
0115 D6B2              FDBADRS  equ   ZPTOS                    ;FDB ADDRESS
0116 D6B2              DATAPTR  equ   UCCMD+2                  ;POINTER TO DATA
0117 D6B2              CPLTVCTR equ   UCCMD+2                  ;COMPLETION VECTOR ADDRESS
0118 D6B2              HOWMANY  equ   DATAPTR+4                ;DATA BYTE COUNT
0119 D6B2              RDMEMPTR equ   DATAPTR+4                ;USED TO GET DATAINPTR FOR RDMEM COMMAND
0120 D6B2              MAXCOUNT equ   DATAPTR+4                ;MAXIMUM BUFFER COUNT-USED IN READBYTES
0121 D6B2              FDBCMD   equ   CPLTVCTR+4               ;FDB COMMAND BYTE-2ND SENT DURING FDBRCV
0122 D6B2              *
0123 D6B2              ;--------------------------------------------
0124 D6B2              ;
0125 D6B2              SCALELNG equ   $000B                    ;LENGTH OF ALL SCALING VALUES
0126 D6B2              PENDBIT  equ   $0080                    ;COMMAND PENDING FLAG BIT
0127 D6B2              ABSBIT   equ   $0040                    ;ABSOLUTE DEVICE AUTO-POLLED (16-BIT)
0128 D6B2              RSPNSBIT equ   $0020                    ;PENDING COMMAND WAS PROCESSED
0129 D6B2              SRQMAX   equ   $10                      ;MAX OF 16 DEVICES (1-16)
0130 D6B2              ERRCODE  equ   $0911                    ;CODE OF SYSTEM DEATH MESSAGE
0131 D6B2              ;--------------------------------------------
0132 D6B2              ;
0133 D6B2              CMDREG   equ   $C026
0134 D6B2              *
0135 D6B2              ;--------------------------------------------
0136 D6B2              ;
0137 D6B2              SCALEDATA equ   $E103D0
0138 D6B2              YMULTIPLY equ   SCALEDATA               ;AREA IN BANK $E1
0139 D6B2              XMULTIPLY equ   YMULTIPLY+2
0140 D6B2              YOFFSET  equ   XMULTIPLY+2
0141 D6B2              XOFFSET  equ   YOFFSET+2
0142 D6B2              YDIVIDE  equ   XOFFSET+2
0143 D6B2              XDIVIDE  equ   YDIVIDE+2
0144 D6B2              VCTRCPLT equ   $E103DC                  ;COMPLETION VECTOR ADDRESS, 4 BYTES
0145 D6B2              SRQTBL   equ   $E1154A                  ;A COMPLETION VECTOR FOR EACH DEVICE
0146 D6B2              PENDFLAG equ   $E10FD6                  ;3rd DATA BUFFER, BANK $E1
0147 D6B2              RSPNSFLAG equ   PENDFLAG                ;SAME LOCATION, BUT CLEAR TO UNDERSTAND
0148 D6B2              FLAGS    equ   PENDFLAG                 ; "
0149 D6B2
0150 D6B2
0151 D6B2
0152 D6B2
0153 D6B2              ;-----------------------------------------------
0154 D6B2              ;
0155 D6B2              ;   Forward addresses and entries
0156 D6B2              ;
0157 D6B2              ;-----------------------------------------------
0158 D6B2
0159 D6B2                       entry ABSOFF
0160 D6B2                       entry ABSON
0161 D6B2                       entry ACTIVE
0162 D6B2                       entry ALL
0163 D6B2                       entry APDOWN
0164 D6B2                       entry APUP
0165 D6B2                       entry BUSY
0166 D6B2                       entry BYTES
0167 D6B2                       entry CALL
0168 D6B2                       entry CHKDOP
0169 D6B2                       entry CLEAN
0170 D6B2                       entry CLRSRQTBL
0171 D6B2                       entry CMDNP
0172 D6B2                       entry CMDP
0173 D6B2                       entry CMDS
0174 D6B2                       entry DBTOE1
0175 D6B2                       entry DONESRQ
0176 D6B2                       entry DUMMY
0177 D6B2                       entry ERRHARD
0178 D6B2                       entry ERRNODEV
0179 D6B2                       entry ERROR3
0180 D6B2                       entry ERRORCALL
0181 D6B2                       entry ERRORDMEM
0182 D6B2                       entry ERRORSND
0183 D6B2                       entry ERROUT
0184 D6B2                       entry ERRRSPNS
0185 D6B2                       entry ERRSRQ
0186 D6B2                       entry ERRSRQFLL
0187 D6B2                       entry EXECMD
0188 D6B2                       entry FDBRCV
0189 D6B2                       entry FDBTALK
0190 D6B2                       entry FDBTIMEOUT
0191 D6B2                       entry GETPATA
0192 D6B2                       entry GETVERSION
0193 D6B2                       entry GOODRSP
0194 D6B2                       entry GOTRSPNS
0195 D6B2                       entry HARDCALL
0196 D6B2                       entry IMD
0197 D6B2                       entry INITOOL
0198 D6B2                       entry INITSKI
0199 D6B2                       entry INTRSPNS
0200 D6B2                       entry INTSRQ
0201 D6B2                       entry ITPLB
0202 D6B2                       entry NOERR
0203 D6B2                       entry NOMORE
0204 D6B2                       entry NORSPNSE
0205 D6B2                       entry NOSTSP
0206 D6B2                       entry NOTABORT
0207 D6B2                       entry NOTSET
0208 D6B2                       entry NXTDEV
0209 D6B2                       entry OFLIST
0210 D6B2                       entry RCVDATA
0211 D6B2                       entry RCVTOOL
0212 D6B2                       entry RDABS
0213 D6B2                       entry RDMEMTOOL
0214 D6B2                       entry RDSCALE
0215 D6B2                       entry READRSPNS
0216 D6B2                       entry RESETSKI
0217 D6B2                       entry RET1
0218 D6B2                       entry RSTSRQ
0219 D6B2                       entry SAVEWD
0220 D6B2                       entry SCALE
0221 D6B2                       entry SCL
0222 D6B2                       entry SCMD
0223 D6B2                       entry SCMD2
0224 D6B2                       entry SDATA
0225 D6B2                       entry SKIPRMV
0226 D6B2                       entry SNDCMDSTR
0227 D6B2                       entry SRQCPL
0228 D6B2                       entry SRQCPLT
0229 D6B2                       entry SRQNOTFND
0230 D6B2                       entry SRQPL
0231 D6B2                       entry SRQRMV
0232 D6B2                       entry STOOL
0233 D6B2                       entry STRVCTR
0234 D6B2                       entry TBL
0235 D6B2                       entry TONOERR
0236 D6B2
0237 D6B2
0238 D6B2
0239 D6B2
0240 D6B2              *********************************************************************
0241 D6B2              *
0242 D6B2              * FUNCTION TABLE
0243 D6B2              *
0244 D6B2              * This code should be at the beginning of the tool set
0245 D6B2              *
0246 D6B2              *********************************************************************
0247 D6B2
0248 D6B2              SKIFNCTBL PROC EXPORT 
0249 D6B2
0250 D6B2                       entry Here
0251 D6B2              Here                                    ; 
0252 D6B2
0253 D6B2 17 00 00 00           DC L:(The-Here)/4              ;num calls +1
0254 D6B6
0255 D6B6                       entry FUNC1
0256 D6B6 0D D7 FC 00  FUNC1    DC L:INITSKI-1                 ;POWER ON - INIT TOOL SET
0257 D6BA                       entry FUNC2
0258 D6BA 7A D7 FC 00  FUNC2    DC L:APUP-1                    ;APPLICATION START UP INIT
0259 D6BE                       entry FUNC3
0260 D6BE 7A D7 FC 00  FUNC3    DC L:APDOWN-1                  ;APPLICATION SHUT DOWN INIT
0261 D6C2                       entry FUNC4
0262 D6C2 46 D7 FC 00  FUNC4    DC L:GETVERSION-1              ;VERSION #
0263 D6C6                       entry FUNC5
0264 D6C6 7A D7 FC 00  FUNC5    DC L:RESETSKI-1                ;RESET
0265 D6CA                       entry FUNC6
0266 D6CA 4C D7 FC 00  FUNC6    DC L:ACTIVE-1                  ;RESERVED
0267 D6CE                       entry FUNC7
0268 D6CE 7A D7 FC 00  FUNC7    DC L:DUMMY-1                   ;RESERVED
0269 D6D2                       entry FUNC8
0270 D6D2 7A D7 FC 00  FUNC8    DC L:DUMMY-1                   ;RESERVED
0271 D6D6              *
0272 D6D6                       entry MYFUNC9
0273 D6D6 4D D9 FC 00  MYFUNC9  DC L:STOOL-1                   ;S
0274 D6DA                       entry MYFUNCA
0275 D6DA 6E D9 FC 00  MYFUNCA  DC L:RCVTOOL-1                 ;RCV
0276 D6DE                       entry MYFUNCB
0277 D6DE 8B D9 FC 00  MYFUNCB  DC L:RDMEMTOOL-1               ;RDMEM
0278 D6E2              ;MYFUNCC DC I4'RESETFDB-1' ;RESET ENTRY	POINT (NOT OFFICIAL CALL)
0279 D6E2                       entry MYFUNCC
0280 D6E2 7A D7 FC 00  MYFUNCC  DC L:DUMMY-1                   ;RESETFDB NO LONGER THERE
0281 D6E6                       entry MYFUNCD
0282 D6E6 C4 D9 FC 00  MYFUNCD  DC L:FDBTALK-1                 ;FDBTALK
0283 D6EA                       entry MYFUNCE
0284 D6EA 0E DA FC 00  MYFUNCE  DC L:FDBRCV-1                  ;FDBRCV
0285 D6EE                       entry MYFUNCF
0286 D6EE 52 D7 FC 00  MYFUNCF  DC L:ABSON-1                   ;ABSOLUTE ON
0287 D6F2                       entry MYFUNC10
0288 D6F2 5E D7 FC 00  MYFUNC10 DC L:ABSOFF-1                  ;ABSOLUTE OFF
0289 D6F6                       entry MYFUNC11
0290 D6F6 6A D7 FC 00  MYFUNC11 DC L:RDABS-1                   ;READ ABSOLUTE ON/OFF
0291 D6FA                       entry MYFUNC12
0292 D6FA 93 D7 FC 00  MYFUNC12 DC L:SCALE-1                   ;SET ABSOLUTE SCALE VALUES
0293 D6FE                       entry MYFUNC13
0294 D6FE 7F D7 FC 00  MYFUNC13 DC L:RDSCALE-1                 ;READ ABSOLUTE SCALE VALUES
0295 D702                       entry MYFUNC14
0296 D702 AB D7 FC 00  MYFUNC14 DC L:SRQPL-1                   ;ADD DEVICE TO SRQ POLL LIST
0297 D706                       entry MYFUNC15
0298 D706 ED D8 FC 00  MYFUNC15 DC L:SRQRMV-1                  ;REMOVE DEVICE FROM SRQ POLL LIST
0299 D70A                       entry MYFUNC16
0300 D70A 40 D9 FC 00  MYFUNC16 DC L:CLRSRQTBL-1               ;CLEAR OUT SRQ TABLE OF ALL ENTRIES
0301 D70E
0302 D70E                       entry The
0303 D70E              The                                     ; 
0304 D70E
0305 D70E
0306 D70E
0307 D70E                       ENDP 
0308 D70E
0309 D70E
0310 D70E              ;         copy  ADBInit
0311 D70E
0312 D70E              ***********************************************************************
0313 D70E              *
0314 D70E              * Init call for tool kit
0315 D70E              * FLAGS -> clear except for ABSBIT (auto-poll on)
0316 D70E              * Put JML op code ($5C) into CPLTVCTR
0317 D70E              * Clear SRQNUM, SRQPTR, SRQMRU, SRQCNT
0318 D70E              * Load in interrupt vectors: SRQ, RESPONSE
0319 D70E              *
0320 D70E              INITSKI  PROC 
0321 D70E
0322 D70E                       longa on
0323 D70E                       longi on
0324 D70E
0325 D70E
0326 D70E                       longa on
0327 D70E                       longi off
0328 D70E
0329 D70E E2 10                 sep   #$10
0330 D710 8B                    phb                            ;SAVE DATA BANK
0331 D711 20 D9 DB              jsr   DBTOE1                   ;Changes data bank register to $E1
0332 D714
0333 D714 A9 40 00              lda   #ABSBIT                  ;SAVE FLAGS (ABSOLUTE ON, OTHERS OFF)
0334 D717 8D D6 0F              sta   |FLAGS                   ;& ZEROS STATUSTMP IN HI BYTE
0335 D71A 9C D8 0F              stz   |SRQNUM                  ;ZERO OUT SRQNUM & SRQCNT
0336 D71D 9C DA 0F              stz   |SRQPTR                  ;ZERO OUT SRQPTR & SRQMRU
0337 D720
0338 D720 A2 0A                 ldx   #$0A                     ;CLR OUT 12 SCALING BYTES
0339 D722                       entry CLRABSDATA
0340 D722 9E D0 03     CLRABSDATA stz   |SCALEDATA,X           ;ZERO OUT ABSOLUTE SCALE DATA
0341 D725 CA                    dex   
0342 D726 10 FA                 bpl   CLRABSDATA
0343 D728
0344 D728              * ;USE A,X APPROPRIATELY FOR 8/16 BIT
0345 D728 A2 5C                 ldx   #JMLOPCODE               ;PATCH OPCODE FOR JMP LONG INTO
0346 D72A 8E DC 03              stx   |VCTRCPLT                ;HI BYTE OF COMPLETION VECTOR
0347 D72D
0348 D72D A2 FC                 ldx   #^INTSRQ                 ;PATCH IN SRQ INTERRUPT VECTOR
0349 D72F 8E 47 00              stx   |IRQ_SRQ+3
0350 D732
0351 D732 A9 3A D8              lda   #INTSRQ
0352 D735 8D 45 00              sta   |IRQ_SRQ+1
0353 D738
0354 D738 A2 FC                 ldx   #^INTRSPNS               ;PATCH IN RESPONSE INTERRUPT VECTOR
0355 D73A 8E 43 00              stx   |IRQ_RESPONSE+3
0356 D73D
0357 D73D A9 65 DB              lda   #INTRSPNS
0358 D740 8D 41 00              sta   |IRQ_RESPONSE+1
0359 D743
0360 D743 C2 10                 rep   #$10
0361 D745                       longi on
0362 D745 80 33                 bra   ITPLB
0363 D747
0364 D747
0365 D747              * Version #
0366 D747              *
0367 D747
0368 D747                       entry GETVERSION
0369 D747              GETVERSION                              ;
0370 D747
0371 D747                       longa on
0372 D747                       longi on
0373 D747
0374 D747 8B                    phb                            ;SAVE DATA BANK FOR SAVEWD
0375 D748 A9 00 03              lda   #FDBVERSION
0376 D74B 80 2B                 bra   SAVEWD                   ;PUSH ONTO STACK AND RETURNS
0377 D74D
0378 D74D              *
0379 D74D                       entry ACTIVE
0380 D74D              ACTIVE                                  ;
0381 D74D
0382 D74D                       longa on
0383 D74D                       longi on
0384 D74D
0385 D74D 8B                    phb   
0386 D74E A9 FF FF              lda   #TRUE                    ;ALWAYS ACTIVE
0387 D751 80 25                 bra   SAVEWD
0388 D753
0389 D753
0390 D753
0391 D753
0392 D753
0393 D753              ;         copy  ADBAbs
0394 D753                       entry ABSTOOL
0395 D753              ABSTOOL  PROC 
0396 D753
0397 D753                       longa on
0398 D753                       longi on
0399 D753
0400 D753              *USING ADBEQUS
0401 D753
0402 D753
0403 D753              *
0404 D753              * ABSON/ABSOFF/RDABS
0405 D753              * Command to enable/disable automatic polling of an absolute device
0406 D753              *
0407 D753
0408 D753                       entry ABSON
0409 D753              ABSON                                   ;       ;USE 16-BIT MODE ON 8-BIT DATA
0410 D753
0411 D753                       longa on
0412 D753                       longi on
0413 D753
0414 D753 8B                    phb   
0415 D754 20 D9 DB              jsr   DBTOE1                   ;Changes data bank register to $E1
0416 D757
0417 D757 A9 40 00              lda   #ABSBIT                  ;GET 16-BIT VALUE (HIGH BYTE CLEAR)
0418 D75A 0C D6 0F              tsb   |FLAGS                   ;SET FLAG BIT (FLAG+1 UNDAMAGED)
0419 D75D
0420 D75D 80 1B                 bra   ITPLB
0421 D75F
0422 D75F
0423 D75F
0424 D75F                       entry ABSOFF
0425 D75F              ABSOFF                                  ;       ;USE 16-BIT MODE ON 8-BIT DATA
0426 D75F
0427 D75F                       longa on
0428 D75F                       longi on
0429 D75F
0430 D75F 8B                    phb   
0431 D760 20 D9 DB              jsr   DBTOE1                   ;Changes data bank register to $E1
0432 D763
0433 D763 A9 40 00              lda   #ABSBIT                  ;GET 16-BIT VALUE (HIGH BYTE CLEAR)
0434 D766 1C D6 0F              trb   |FLAGS                   ;CLEAR FLAG BIT (FLAG+1 UNDAMAGED)
0435 D769 80 0F                 bra   ITPLB
0436 D76B
0437 D76B
0438 D76B                       entry RDABS
0439 D76B              RDABS                                   ;       ;16-BIT MODE INSTRUCTION
0440 D76B
0441 D76B                       longa on
0442 D76B                       longi on
0443 D76B
0444 D76B 8B                    phb   
0445 D76C 20 D9 DB              jsr   DBTOE1                   ;Changes data bank register to $E1
0446 D76F
0447 D76F A9 00 00              lda   #$0000                   ;ABSBIT STORED AS BOOLEAN 1=TRUE,0=FALSE
0448 D772 2C D5 0F              bit   |FLAGS-1                 ;FAKE 16-BIT MODE INTO SETTING V FLAG
0449 D775 50 01                 bvc   SAVEWD                   ; PUTS BOOLEAN 0=FALSE 1=TRUE
0450 D777 1A                    inc   a                        ;INVERT TO TRUE
0451 D778
0452 D778
0453 D778                       entry SAVEWD
0454 D778              SAVEWD                                  ;
0455 D778
0456 D778 83 08                 sta   $8,S                     ;PUT BOOLEAN DIRECTLY INTO STACK
0457 D77A
0458 D77A
0459 D77A                       entry ITPLB
0460 D77A              ITPLB                                   ;
0461 D77A AB                    plb   
0462 D77B
0463 D77B              * Application Start-up
0464 D77B              * Application Shut-down
0465 D77B              *
0466 D77B                       entry APUP
0467 D77B              APUP                                    ;
0468 D77B                       entry APDOWN
0469 D77B              APDOWN                                  ;
0470 D77B                       entry DUMMY
0471 D77B              DUMMY                                   ;
0472 D77B                       entry RESETSKI
0473 D77B              RESETSKI                                ;
0474 D77B                       entry IT
0475 D77B              IT                                      ;
0476 D77B
0477 D77B                       longa on
0478 D77B                       longi on
0479 D77B              *
0480 D77B A9 00 00              lda   #$0000
0481 D77E 18                    clc   
0482 D77F 6B                    rtl   
0483 D780
0484 D780              *
0485 D780              * SCALE/RDSCALE
0486 D780              * Routine to set/read the scaling values for absolute devices
0487 D780              *
0488 D780
0489 D780                       entry RDSCALE
0490 D780              RDSCALE                                 ;       ;ENTRY POINT FOR READING SCALE VALUES
0491 D780
0492 D780                       longa on
0493 D780                       longi on
0494 D780
0495 D780 0B                    phd   
0496 D781 08                    php   
0497 D782 8B                    phb   
0498 D783 20 8F DB              jsr   INITOOL
0499 D786                       longa off
0500 D786                       longi on
0501 D786 1B                    tcs   
0502 D787              *
0503 D787 A0 0B 00              ldy   #SCALELNG                ;LENGTH OF SCALING VALUES
0504 D78A                       entry GETSCALE
0505 D78A B9 D0 03     GETSCALE lda   |SCALEDATA,Y             ;GET SCALE VALUE
0506 D78D 97 20                 sta   [<ZPTOS],Y
0507 D78F 88                    dey   
0508 D790 10 F8                 bpl   GETSCALE
0509 D792              *
0510 D792 80 12                 bra   SCL
0511 D794
0512 D794
0513 D794
0514 D794                       entry SCALE
0515 D794              SCALE                                   ;       ;ENTRY POINT FOR SETTING SCALE VALUES
0516 D794
0517 D794                       longa on
0518 D794                       longi on
0519 D794
0520 D794 0B                    phd   
0521 D795 08                    php   
0522 D796 8B                    phb   
0523 D797 20 8F DB              jsr   INITOOL
0524 D79A                       longa off
0525 D79A                       longi on
0526 D79A 1B                    tcs   
0527 D79B              *
0528 D79B A0 0B 00              ldy   #SCALELNG                ;LENGTH OF SCALING VALUES
0529 D79E                       entry STRSCALE
0530 D79E B7 20        STRSCALE lda   [<ZPTOS],Y               ;GET SCALE VALUE
0531 D7A0 99 D0 03              sta   |SCALEDATA,Y             ;AND SAVE IT
0532 D7A3 88                    dey   
0533 D7A4 10 F8                 bpl   STRSCALE
0534 D7A6              *
0535 D7A6                       entry SCL
0536 D7A6 A2 04 00     SCL      ldx   #4                       ;CLEAN UP 4 BYTES
0537 D7A9 4C 9D DB              jmp   NOERR                    ;
0538 D7AC
0539 D7AC
0540 D7AC
0541 D7AC
0542 D7AC              ;         copy  ADBSrq
0543 D7AC              * uC TOOL SET - SRQ COMMANDS.
0544 D7AC              *
0545 D7AC              * SRQPL
0546 D7AC              * Installs new device into SRQ TABLE to be polled when an SRQ occurs
0547 D7AC              * on FDB. If data is received from that device then it is passed to
0548 D7AC              * completion vector and the device is put in SRQMRU.
0549 D7AC              * Routine starts by verifying that a device exists at
0550 D7AC              * address designated. It does this by sing the FDB talk command
0551 D7AC              * to the ID register (3) and getting a response. If a command
0552 D7AC              * is already pending then it reads it before starting ID. Since
0553 D7AC              * the ID command also reads a response it must not clobber the
0554 D7AC              * data stored in response buffer (ignores ID data instead).
0555 D7AC              * After routine has determined that device exists at specified
0556 D7AC              * address adds one more device to SRQNUM and SRQ TABLE if there
0557 D7AC              * is room for one more.
0558 D7AC              * Finally the devices completion vector is stored at the  of
0559 D7AC              * the SRQTBL, along with the FDB address/register.
0560 D7AC              *
0561 D7AC              * Variables:
0562 D7AC              * SRQTBL = Table of SRQ devices - each device requires 4 bytes
0563 D7AC              * Byte 0 -> FDB Address & Register
0564 D7AC              * Bytes 1-3 -> Completion Vector Address (1=low, 3=bank)
0565 D7AC              * SRQMAX = Maximum number of entries allowed in SRQ table
0566 D7AC              * SRQNUM = Number of devices currently installed in SRQ table
0567 D7AC              * SRQPTR = Pointer to next device in SRQ table to be polled(1..SRQNUM)
0568 D7AC              * SRQMRU = Most recent device in table to return data
0569 D7AC              * SRQCNT = Count of number of devices polled since data was received
0570 D7AC              * from most recently used device - SRQMRU (SRQNUM..1).
0571 D7AC              *
0572 D7AC              *
0573 D7AC                       entry ADBSRQST
0574 D7AC              ADBSRQST PROC 
0575 D7AC
0576 D7AC                       longa on
0577 D7AC                       longi on
0578 D7AC
0579 D7AC              *USING ADBEQUS
0580 D7AC
0581 D7AC              *
0582 D7AC                       entry SRQPL
0583 D7AC              SRQPL                                   ;       
0584 D7AC
0585 D7AC                       longa on
0586 D7AC                       longi on
0587 D7AC
0588 D7AC 0B                    phd                            ;SAVE DIRECT PAGE
0589 D7AD 08                    php                            ;SAVE INTERRUPT STATUS
0590 D7AE 8B                    phb                            ;SAVE DATA BANK
0591 D7AF 20 8F DB              jsr   INITOOL                  ;DO INIT STUFF
0592 D7B2                       longa off
0593 D7B2                       longi on
0594 D7B2 1B                    tcs                            ;OPENS UP BUFFER INSIDE STACK
0595 D7B3              *
0596 D7B3 A5 25                 lda   <CPLTVCTR+3              ;MAKE SURE HI BYTE OF VECTOR=0
0597 D7B5 D0 77                 bne   ERRSRQ                   ;NOT =0 THEN FLAG ERROR
0598 D7B7              *
0599 D7B7 20 62 DA              jsr   CHKDOP                   ;IF PING FLAG SET THEN READ RESPONSE
0600 D7BA B0 72                 bcs   ERRSRQ                   ;ERROR ENCOUNTERED
0601 D7BC              *
0602 D7BC A5 20                 lda   <FDBADRS                 ;GET FDB ADDRESS
0603 D7BE 29 0F                 and   #$0F                     ;MASK OFF EVERYTHING ELSE
0604 D7C0 09 F0                 ora   #IDREG                   ;APP FDB ID REG.
0605 D7C2 20 B6 DA              jsr   SDATA                    ;S COMMAND
0606 D7C5 B0 67                 bcs   ERRSRQ
0607 D7C7              *
0608 D7C7                       longa on
0609 D7C7 C2 20                 rep   #$20                     ;16-BIT
0610 D7C9 7B                    tdc                            ;MAKE ROOM FOR RESPONSE BY MOVING
0611 D7CA 69 0A 00              adc   #$000A                   ;DIRECT PAGE - CARRY CLEAR FROM ABOVE
0612 D7CD 5B                    tcd                            ;RESPONSE PUT IN BOTTOM (0-9) DIRECT PG
0613 D7CE                       longa off
0614 D7CE E2 20                 sep   #$20
0615 D7D0              *
0616 D7D0 20 36 DB              jsr   READRSPNS                ;GET ID RESPONSE
0617 D7D3 08                    php                            ;SAVE CARRY
0618 D7D4              *
0619 D7D4                       longa on
0620 D7D4 C2 20                 rep   #$20                     ;16-BIT M
0621 D7D6 7B                    tdc                            ;MAKE ROOM FOR RESPONSE BY MOVING
0622 D7D7 E9 09 00              sbc   #$0009                   ;DIRECT PAGE - CARRY CLEAR FROM ABOVE
0623 D7DA 5B                    tcd                            ;RESPONSE PUT IN BOTTOM (0-9) DIRECT PG
0624 D7DB                       longa off
0625 D7DB E2 20                 sep   #$20                     ;8-BIT M
0626 D7DD              *
0627 D7DD 28                    plp                            ;GET CARRY
0628 D7DE B0 4E                 bcs   ERRSRQ                   ;CHK IF ERROR ENCOUNTERED ON RESPONSE
0629 D7E0 A5 0A                 lda   <RSPNSBUF+RSPNSLNG       ;CHECK IF ID EXISTS
0630 D7E2 F0 3A                 beq   ERRNODEV                 ;NO DEVICE AT SPECIFIED ADDRESS
0631 D7E4              *
0632 D7E4 AD D8 0F              lda   |SRQNUM                  ;GET SRQ NUMBER
0633 D7E7 C9 10                 cmp   #SRQMAX                  ;AND CHECK IF MAX
0634 D7E9 B0 3B                 bcs   ERRSRQFLL                ;SRQ LIST FULL
0635 D7EB A8                    tay                            ;SAVE OFF SRQ INDEX
0636 D7EC 0A                    asl   a                        ;GET INDEX INTO SRQTBL BY MULTPLYING
0637 D7ED 0A                    asl   a                        ;BY 4
0638 D7EE EB                    xba   
0639 D7EF A9 00                 lda   #0                       ;CLEAR OUT HI BYTE
0640 D7F1 EB                    xba   
0641 D7F2 AA                    tax   
0642 D7F3 C8                    iny                            ;MOVE INDEX
0643 D7F4 98                    tya                            ;AND SAVE IN INDEX POINTER
0644 D7F5 8D D9 0F              sta   |SRQCNT                  ;RESTORE COUNT
0645 D7F8 8D D8 0F              sta   |SRQNUM                  ;STILL ROOM SO ADD 1 MORE
0646 D7FB
0647 D7FB A5 20                 lda   <FDBADRS                 ;MOVE FDB ADDRESS/REGISTER
0648 D7FD 9D 4A 15              sta   |SRQTBL,X                ; INTO SRQTBL (8-BIT)
0649 D800
0650 D800 A5 22                 lda   <CPLTVCTR                ;MOVE HI ADRS OF COMPLETION VECTOR
0651 D802 9D 4B 15              sta   |SRQTBL+1,X              ;INTO TABLE
0652 D805
0653 D805 A5 23                 lda   <CPLTVCTR+1              ;
0654 D807 9D 4C 15              sta   |SRQTBL+2,X
0655 D80A
0656 D80A A5 24                 lda   <CPLTVCTR+2              ;MOVE BANK OF COMPLETION VECTOR
0657 D80C 9D 4D 15              sta   |SRQTBL+3,X
0658 D80F
0659 D80F 9C DA 0F              stz   |SRQPTR                  ;RESET POINTER TO BEGIN
0660 D812 9C DB 0F              stz   |SRQMRU                  ;RESET MRU TO ZERO
0661 D815              *
0662 D815 20 CE DA              jsr   IMD                      ;PROCESS ANY PING STATUS
0663 D818 A2 06 00              ldx   #$0006                   ;CLEAN 6 BYTES OFF STACK
0664 D81B 4C 9D DB              jmp   NOERR                    ;AND NO ERROR
0665 D81E
0666 D81E                       entry ERRNODEV
0667 D81E 20 CE DA     ERRNODEV jsr   IMD                      ;PROCESS ANY PING STATUS
0668 D821 A0 83 00              ldy   #NODEVERR                ;FLAG NO DEVICE ERROR
0669 D824 80 0E                 bra   ERRHARD
0670 D826
0671 D826                       entry ERRSRQFLL
0672 D826 20 CE DA     ERRSRQFLL jsr   IMD                     ;FLAG FULL ERROR
0673 D829 A0 84 00              ldy   #FULLERR
0674 D82C 80 06                 bra   ERRHARD
0675 D82E
0676 D82E                       entry ERRSRQ
0677 D82E 20 CE DA     ERRSRQ   jsr   IMD                      ;PROCESS ANY PING STATUS
0678 D831 A0 10 00              ldy   #HARDERR                 ;FLAG ERROR
0679 D834
0680 D834                       entry ERRHARD
0681 D834 A2 06 00     ERRHARD  ldx   #$0006                   ;CLEAN 6 BYTES OFF STACK
0682 D837 4C A4 DB              jmp   CALL                     ;FLAG ERROR ON RETURN
0683 D83A
0684 D83A              *
0685 D83A              * SRQ INTERRUPT HANDLER
0686 D83A              * This code is entry point for SRQ interrupt handler
0687 D83A              * If a command is already ping then the SRQ is ignored
0688 D83A              * Gets next device in SRQ TABLE and initiates
0689 D83A              * FDB poll.
0690 D83A              * Address of next device is stored in SRQTBL.
0691 D83A              * Get index into SRQTBL by incrementing SRQPTR. If 
0692 D83A              * of table (SRQNUM) then set to 0. SRQMRU is used to keep track of
0693 D83A              * the last device that was active. If all devices in SRQTBL are polled
0694 D83A              * and none responded then routine turns off SRQ on all devices, except
0695 D83A              * keyboard (2), then reenables SRQ for all devices installed in
0696 D83A              * SRQ TABLE.
0697 D83A              *
0698 D83A              * Enter in 8-bit m,x
0699 D83A              *
0700 D83A
0701 D83A                       entry INTSRQ
0702 D83A              INTSRQ                                  ;       
0703 D83A
0704 D83A                       longa off
0705 D83A                       longi off
0706 D83A
0707 D83A 0B                    phd                            ;SAVE DIRECT PAGE
0708 D83B 08                    php                            ;SAVE INTERRUPT STATUS
0709 D83C 8B                    phb                            ;SAVE DATA BANK
0710 D83D                       longa on
0711 D83D                       longi on
0712 D83D C2 30                 rep   #$30                     ;NEED TO BE IN 16-BIT FOR INIT
0713 D83F 20 8F DB              jsr   INITOOL                  ;DO INIT STUFF/Returns 'm'=1/'x'=0
0714 D842                       longa off
0715 D842 1B                    tcs                            ;OPENS UP BUFFER INSIDE STACK
0716 D843 AD D6 0F              lda   |PENDFLAG                ;CHECK PING FLAG (DON'T SET)
0717 D846 30 34                 bmi   DONESRQ                  ;IF SET THEN RETURN
0718 D848              *
0719 D848 CE D9 0F              dec   |SRQCNT                  ;CHECK IF ALL DEVICES POLLED
0720 D84B 30 34                 bmi   OFLIST                   ;YES
0721 D84D AD DA 0F              lda   |SRQPTR                  ;GET POINTER
0722 D850 CD D8 0F              cmp   |SRQNUM                  ;CHECK IF  OF TABLE
0723 D853 90 05                 bcc   TBL                      ;NOT YET
0724 D855 A9 00                 lda   #$00                     ;GOT  - RESET BACK TO BEGINNING
0725 D857 8D DA 0F              sta   |SRQPTR                  ; (PUT DATA IN A-REG.)
0726 D85A              *
0727 D85A                       entry TBL
0728 D85A              TBL                                     ; 
0729 D85A EE DA 0F              inc   |SRQPTR                  ;SETUP FOR NEXT DEVICE
0730 D85D 0A                    asl   a                        ;A HOLDS CURRENT DEVICE
0731 D85E 0A                    asl   a                        ;CALCULATES LOCATION OF FDB ADDRESS IN
0732 D85F EB                    xba   
0733 D860 A9 00                 lda   #$00
0734 D862 EB                    xba   
0735 D863 AA                    tax                            ;SRQTBL
0736 D864              *
0737 D864 A0 C7 D8              ldy   #SRQCPLT                 ;MOVE LOW WORD OF SRQ COMPLETION
0738 D867 8C DD 03              sty   |VCTRCPLT+1              ;ROUTINE ADDRESS INTO COMPLETION VECTOR
0739 D86A A9 FC                 lda   #^SRQCPLT                ;GET BANK INTO HI BYTE OF VECTOR
0740 D86C 8D DF 03              sta   |VCTRCPLT+3
0741 D86F              *
0742 D86F BD 4A 15              lda   |SRQTBL,X                ;GET FDB ADDRESS/REGISTER
0743 D872 09 C0                 ora   #TALKCMD                 ;MAKE INTO FDB TALK POLL COMMAND
0744 D874 8D 26 C0              sta   |CMDREG                  ;S COMMAND
0745 D877 A9 80                 lda   #PENDBIT                 ;SET COMMAND PING FLAG
0746 D879 0C D6 0F              tsb   |FLAGS
0747 D87C                       entry DONESRQ
0748 D87C              DONESRQ                                 ; 
0749 D87C C2 30                 rep   #$30                     ;16-BIT M,X
0750 D87E                       longa on
0751 D87E                       longi on
0752 D87E 4C CE DB              jmp   CLEAN                    ;(RETURN FROM INTERRUPT)
0753 D881
0754 D881              *
0755 D881              * This Routine is used if no device in the SRQ list has returned data.
0756 D881              * This probably means that some device is generating an SRQ when it
0757 D881              * it shouldn't be. To alleviate this problem, the SRQ of all devices,
0758 D881              * except for the keyboard (2), is disabled and then those in the SRQ
0759 D881              * list are enabled.
0760 D881              *
0761 D881
0762 D881                       entry OFLIST
0763 D881              OFLIST                                  ; 
0764 D881
0765 D881                       longa off
0766 D881
0767 D881 A9 0F                 lda   #$0F
0768 D883 8D DA 0F              sta   |SRQPTR                  ;USE AS TEMPORARY
0769 D886              *
0770 D886                       entry ANYMORE
0771 D886 AD DA 0F     ANYMORE  lda   |SRQPTR                  ;GET NEXT DEVICE ADDRESS
0772 D889 C9 02                 cmp   #2                       ;LOOK FOR KEYBOARD ADDRESS
0773 D88B D0 01                 bne   NXTDEV
0774 D88D 3A                    dec   a                        ;SKIP KEYBOARD
0775 D88E
0776 D88E                       entry NXTDEV
0777 D88E 09 70        NXTDEV   ora   #DISSRQ                  ;APP FDB COMMAND TO FDB ADDRESS
0778 D890 20 52 DA              jsr   CMDS                     ;SS COMMAND AND WAIT UNTIL READ
0779 D893 CE DA 0F              dec   |SRQPTR                  ;GET NEXT ADDRESS
0780 D896 10 EE                 bpl   ANYMORE                  ;UNTIL NO MORE
0781 D898              *
0782 D898 AD D8 0F              lda   |SRQNUM                  ;GET NUMBER OF DEVICES IN SRQ TABLE
0783 D89B 8D DA 0F              sta   |SRQPTR
0784 D89E
0785 D89E                       entry GETIND
0786 D89E CE DA 0F     GETIND   dec   |SRQPTR                  ;GET INDEX TO NEXT DEVICE ADDRESS
0787 D8A1
0788 D8A1 AD DA 0F              lda   |SRQPTR
0789 D8A4 30 13                 bmi   RSTSRQ                   ;0 = LAST DEVICE
0790 D8A6 0A                    asl   a                        ;MAKE INDEX INTO SRQ TABLE
0791 D8A7 0A                    asl   a
0792 D8A8 EB                    xba   
0793 D8A9 A9 00                 lda   #0
0794 D8AB EB                    xba   
0795 D8AC A8                    tay   
0796 D8AD B9 4A 15              lda   |SRQTBL,Y                ;GET FDB ADDRESS FROM TABLE
0797 D8B0 29 0F                 and   #$0F                     ;CLEAR OUT REGISTER
0798 D8B2 09 50                 ora   #ENSRQ                   ;APP FDB COMMAND TO FDB ADDRESS
0799 D8B4 20 52 DA              jsr   CMDS                     ;SS COMMAND AND WAITS TIL READ
0800 D8B7 80 E5                 bra   GETIND
0801 D8B9              *
0802 D8B9                       entry RSTSRQ
0803 D8B9 AD DB 0F     RSTSRQ   lda   |SRQMRU                  ;GET MOST RECENTLY USED DEVICE
0804 D8BC 8D DA 0F              sta   |SRQPTR                  ;AND SET POINTER TO IT
0805 D8BF AD D8 0F              lda   |SRQNUM                  ;CHECK ALL TABLE ENTRIES AGAIN
0806 D8C2 8D D9 0F              sta   |SRQCNT
0807 D8C5 80 B5                 bra   DONESRQ
0808 D8C7
0809 D8C7
0810 D8C7              *
0811 D8C7              * SRQ COMPLETION ROUTINE
0812 D8C7              * This routine is used to process a response from a FDB poll command
0813 D8C7              * initiated by the SRQ interrupt handler. The SRQ handler is trying
0814 D8C7              * to get data from a device which sent an SRQ to the system.
0815 D8C7              * The response to the poll command was read by the response
0816 D8C7              * interrupt handler or during another FDB command.
0817 D8C7              * If the response from the command shows no data then
0818 D8C7              * the routine just returns. Later, an SRQ interrupt will enable the
0819 D8C7              * SRQ interrupt handler to initiate a poll of the next device in the
0820 D8C7              * SRQ TABLE.
0821 D8C7              * If the response shows data was returned then this routine will
0822 D8C7              * update the SRQMRU (Most Recently Used) with the number of the
0823 D8C7              * active device. The routine will then
0824 D8C7              * Call the completion vector address for the active device.
0825 D8C7              * A typical completion routine should muck w/ the stack to find
0826 D8C7              * the data. This doesn't because it knows where it is.
0827 D8C7              *
0828 D8C7              * Assumes 8-bit m,x & data stored in direct page locations
0829 D8C7              * Don't clean up before return
0830 D8C7              *
0831 D8C7
0832 D8C7                       entry SRQCPLT
0833 D8C7              SRQCPLT                                 ; 
0834 D8C7
0835 D8C7 A5 00                 lda   <RSPNSBUF                ;GET # OF BYTES RECEIVED
0836 D8C9 F0 1F                 beq   SRQCPL                   ;IF NO BYTES THEN RETURN
0837 D8CB              *
0838 D8CB 4B                    phk                            ;PUSH RETURN ADRS (PROGRAM BANK 1ST)
0839 D8CC 62 1A 00              per   SRQCPL-1                 ;AFTER COMPLETION VECTOR RETURN->
0840 D8CF AD D8 0F              lda   |SRQNUM                  ;RESTORE COUNTER - INDICATES # OF
0841 D8D2 8D D9 0F              sta   |SRQCNT                  ; DEVICES IN TABLE
0842 D8D5 AD DA 0F              lda   |SRQPTR                  ;SRQPTR POINTS TO NEXT DEVICE
0843 D8D8 3A                    dec   a                        ;SET TO ACTIVE DEVICE
0844 D8D9 8D DB 0F              sta   |SRQMRU                  ;AND SAVE AS MOST RECENTLY USED
0845 D8DC 0A                    asl   a                        ;GET COMPLETION VECTOR ONTO STACK
0846 D8DD 0A                    asl   a                        ;ADDRESS STORED IN SRQTBL
0847 D8DE AA                    tax                            ;INDEX INTO SRQTBL
0848 D8DF BD 4D 15              lda   |SRQTBL+3,X              ;PUSH PROGRAM BANK # OF ADDRESS ON 1ST
0849 D8E2 48                    pha                            ;PUSH ADDRESS ON STACK THEN RTL
0850 D8E3                       longa on
0851 D8E3                       longi on
0852 D8E3 C2 30                 rep   #$30                     ;16-BIT MODE
0853 D8E5 BD 4B 15              lda   |SRQTBL+1,X              ;GET ADDRESS WORD
0854 D8E8 3A                    dec   a                        ;-1 (USES RTL)
0855 D8E9 48                    pha                            ;PUSH HI BYTE, THEN LOW BYTE
0856 D8EA
0857 D8EA                       entry SRQCPL
0858 D8EA              SRQCPL                                  ;Returns here from completion vector
0859 D8EA E2 30                 sep   #$30                     ;Call completion vector routine (8-bit)
0860 D8EC                       longa off
0861 D8EC                       longi off
0862 D8EC 18                    clc                            ;2ND THRU RTNS (CLC)->INTRPT DISPATCHER
0863 D8ED 6B                    rtl                            ;BACK TO SYSTEM INTERRUPT HANDLER
0864 D8EE
0865 D8EE              *
0866 D8EE              * Removes a device from SRQ list
0867 D8EE              * Looks in SRQ table for FDB address passed on stack by calling
0868 D8EE              * routine. If FDB address is in table then removes entry from table,
0869 D8EE              * moves rest of entries up in table.
0870 D8EE              *
0871 D8EE
0872 D8EE                       entry SRQRMV
0873 D8EE              SRQRMV                                  ;       
0874 D8EE
0875 D8EE                       longa on
0876 D8EE                       longi on
0877 D8EE
0878 D8EE 0B                    phd   
0879 D8EF 08                    php   
0880 D8F0 8B                    phb   
0881 D8F1 20 8F DB              jsr   INITOOL                  ;Returns 'm'=1/'x'=0
0882 D8F4                       longa off
0883 D8F4 1B                    tcs   
0884 D8F5
0885 D8F5 AD D6 0F              lda   |PENDFLAG                ;COMMAND PING SO DON'T ATTEMPT
0886 D8F8 E2 30                 sep   #$30
0887 D8FA                       longi off
0888 D8FA 30 3A                 bmi   SKIPRMV                  ;TO REMOVE DEVICE
0889 D8FC
0890 D8FC AE D8 0F              ldx   |SRQNUM                  ;START W/ LAST DEVICE IN SRQ TABLE
0891 D8FF                       entry SAMEDEV
0892 D8FF CA           SAMEDEV  dex                            ;GET INDEX FOR DEVICE N =>(N-1)*4
0893 D900 30 3B                 bmi   SRQNOTFND                ;CAN'T FIND DEVICE IN TABLE
0894 D902 8A                    txa                            ;BUILD INDEX IN TO TABLE
0895 D903 0A                    asl   a                        ;
0896 D904 0A                    asl   a
0897 D905 A8                    tay   
0898 D906 B9 4A 15              lda   |SRQTBL,Y                ;GET ADDRESS OF DEVICE IN TABLE
0899 D909 C5 20                 cmp   <ZPTOS                   ;AND SEE IF DEVICE TO BE REMOVED
0900 D90B D0 F2                 bne   SAMEDEV                  ;NOT SAME - GET NEXT DEVICE IN TABLE
0901 D90D
0902 D90D C2 20                 rep   #$20
0903 D90F                       longa on
0904 D90F
0905 D90F                       entry FINDDEV
0906 D90F B9 50 15     FINDDEV  lda   |SRQTBL+6,Y              ;FOUND DEVICE
0907 D912 99 4C 15              sta   |SRQTBL+2,Y              ;MOVE NEXT ENTRY IN TABLE UP ONE
0908 D915 B9 4E 15              lda   |SRQTBL+4,Y
0909 D918 99 4A 15              sta   |SRQTBL+0,Y
0910 D91B C8                    iny   
0911 D91C C8                    iny   
0912 D91D C8                    iny   
0913 D91E C8                    iny   
0914 D91F E8                    inx                            ;SEE IF LAST ENTRY IN TABLE
0915 D920 EC D8 0F              cpx   |SRQNUM
0916 D923 90 EA                 bcc   FINDDEV                  ;NOT LAST ENTRY, MOVE ANOTHER ONE
0917 D925              *
0918 D925 CE D8 0F              dec   |SRQNUM                  ;LAST ENTRY MOVED - 1 LESS TABLE ENTRY
0919 D928 AE D8 0F              ldx   |SRQNUM                  ;USE X - 8-BIT
0920 D92B 8E D9 0F              stx   |SRQCNT                  ;RESTORE
0921 D92E 9C DA 0F              stz   |SRQPTR                  ;ZEROS OUT BOTH SRQPTR AND SRQMRU
0922 D931 A2 02                 ldx   #2
0923 D933 4C 9D DB              jmp   NOERR
0924 D936              *
0925 D936                       entry SKIPRMV
0926 D936              SKIPRMV                                 ; 
0927 D936 A0 82                 ldy   #BUSYERR
0928 D938                       entry SRQ
0929 D938 A2 02        SRQ      ldx   #2
0930 D93A 4C A4 DB              jmp   CALL
0931 D93D              *
0932 D93D                       entry SRQNOTFND
0933 D93D              SRQNOTFND                               ; 
0934 D93D A0 10                 ldy   #HARDERR
0935 D93F 80 F7                 bra   SRQ
0936 D941
0937 D941              *
0938 D941              * Clear out the SRQ Table of all entries
0939 D941              *
0940 D941
0941 D941                       entry CLRSRQTBL
0942 D941              CLRSRQTBL                               ;       
0943 D941
0944 D941                       longa on
0945 D941                       longi on
0946 D941
0947 D941 A9 00 00              lda   #$0000
0948 D944 8F D8 0F E1           sta   >SRQNUM                  ;ZEROS SRQNUM AND SRQCNT
0949 D948 8F DA 0F E1           sta   >SRQPTR                  ;ZEROS SRQPTR AND SRQMRU
0950 D94C 18                    clc   
0951 D94D 6B                    rtl   
0952 D94E
0953 D94E
0954 D94E
0955 D94E
0956 D94E              ;         copy  ADBTools
0957 D94E              * uC TOOL SET - SKI	COMMANDS.
0958 D94E
0959 D94E              * ADBTOOLS
0960 D94E
0961 D94E              *
0962 D94E              * S TOOL
0963 D94E              * This routine is used to implement the S tool
0964 D94E              * Since this command is an immediate command it checks if ping
0965 D94E              * command flag is set. If no ping command it executes immediately.
0966 D94E              * If command ping then the ping command must be finished 1st.
0967 D94E              * READRSPNS gets data from the ping command. The immediate
0968 D94E              * command is then executed and afterwards the data from the ping
0969 D94E              * command is processed by vectoring to the completion routine.
0970 D94E              *
0971 D94E                       entry TOOLADB
0972 D94E              TOOLADB  PROC 
0973 D94E
0974 D94E              *USING ADBEQUS
0975 D94E              *USING E1VECTORS
0976 D94E
0977 D94E
0978 D94E                       EXPORT STOOL 
0979 D94E              STOOL                                   ;       
0980 D94E
0981 D94E                       longa on
0982 D94E                       longi on
0983 D94E
0984 D94E 0B                    phd                            ;SAVE DIRECT PAGE
0985 D94F 08                    php                            ;SAVE INTERRUPT STATUS
0986 D950 8B                    phb                            ;SAVE DATA BANK
0987 D951 20 8F DB              jsr   INITOOL                  ;DO INIT STUFF
0988 D954                       longa off
0989 D954 1B                    tcs                            ;OPENS UP BUFFER INSIDE STACK
0990 D955              *
0991 D955 20 4B DA              jsr   SCMD
0992 D958 B0 0D                 bcs   ERRORCALL
0993 D95A 20 73 DA              jsr   SNDCMDSTR
0994 D95D B0 08                 bcs   ERRORCALL
0995 D95F              *
0996 D95F                       entry TOOL
0997 D95F 20 CE DA     TOOL     jsr   IMD                      ;CLEAN UP ANY PING STATUS
0998 D962              *
0999 D962              * Clean up stack and finish call
1000 D962              *
1001 D962              *
1002 D962 A2 08 00              ldx   #$0008                   ;CLEAN OFF 8 INPUT PARAMETERS
1003 D965 80 4F                 bra   TONOERR                  ;
1004 D967              *
1005 D967                       entry ERRORCALL
1006 D967              ERRORCALL                               ; 
1007 D967 20 CE DA              jsr   IMD                      ;CLEAN UP ANY PING STATUS
1008 D96A A2 08 00              ldx   #$0008                   ;CLEAN OFF 8 INPUT PARAMETERS
1009 D96D 80 50                 bra   HARDCALL
1010 D96F
1011 D96F
1012 D96F              * RCV TOOL
1013 D96F              * This routine is used to implement the RCV tool
1014 D96F              * Since this command is an immediate command it checks if ping
1015 D96F              * command flag is set. If no ping command it executes immediately.
1016 D96F              * If command ping then the ping command must be finished 1st.
1017 D96F              * READRSPNS gets data from the ping command. The immediate
1018 D96F              * command is then executed and afterwards the data from the ping
1019 D96F              * command is processed by vectoring to the completion routine.
1020 D96F
1021 D96F                       entry RCVTOOL
1022 D96F              RCVTOOL                                 ;       
1023 D96F
1024 D96F                       longa on
1025 D96F                       longi on
1026 D96F
1027 D96F 0B                    phd                            ;SAVE DIRECT PAGE
1028 D970 08                    php                            ;SAVE INTERRUPT STATUS
1029 D971 8B                    phb                            ;SAVE DATA BANK
1030 D972 20 8F DB              jsr   INITOOL                  ;DO INIT STUFF
1031 D975                       longa off
1032 D975 1B                    tcs                            ;OPENS UP BUFFER INSIDE STACK
1033 D976              *
1034 D976 20 4B DA              jsr   SCMD                     ;S IT COMMAND
1035 D979              *  ;LEAVES W/DATA REG. CLEAR
1036 D979 B0 EC                 bcs   ERRORCALL                ;ERROR-ABORT THE REST
1037 D97B              *
1038 D97B A0 00 00              ldy   #$0000                   ;SET UP DATA COUNTER
1039 D97E
1040 D97E                       entry ANYDATA
1041 D97E C4 26        ANYDATA  cpy   <HOWMANY                 ;SEE IF ANY MORE DATA TO RECEIVE
1042 D980
1043 D980 B0 DD                 bcs   TOOL                     ;NO MORE SO GOTO  OF IMMEDIATE TOOL
1044 D982 20 22 DB              jsr   RCVDATA                  ;GET DATA
1045 D985 B0 E0                 bcs   ERRORCALL                ;ERROR-ABORT THE REST
1046 D987 97 22                 sta   [<DATAPTR],Y             ;SAVE DATA
1047 D989 C8                    iny                            ;GET NEXT BYTE
1048 D98A 80 F2                 bra   ANYDATA
1049 D98C
1050 D98C
1051 D98C              * RDMEM
1052 D98C              * Command to read memory location from the uC
1053 D98C              * Needs both input and output
1054 D98C              * Command starts by calling the Command string
1055 D98C
1056 D98C                       entry RDMEMTOOL
1057 D98C              RDMEMTOOL                               ;       
1058 D98C
1059 D98C                       longa on
1060 D98C                       longi on
1061 D98C
1062 D98C 0B                    phd                            ;SAVE DIRECT PAGE
1063 D98D 08                    php                            ;SAVE INTERRUPT STATUS
1064 D98E 8B                    phb                            ;SAVE DATA BANK
1065 D98F 20 8F DB              jsr   INITOOL                  ;DO INIT STUFF
1066 D992                       longa off
1067 D992 1B                    tcs                            ;OPENS UP BUFFER INSIDE STACK
1068 D993              *
1069 D993 20 4B DA              jsr   SCMD                     ;S COMMAND BYTE
1070 D996 B0 21                 bcs   ERRORDMEM                ;ERROR-ABORT REST OF COMMAND
1071 D998 A7 22                 lda   [<DATAPTR]               ;GET 1ST DATA BYTE (LOW ADDRESS)
1072 D99A 20 B6 DA              jsr   SDATA                    ; AND S IT
1073 D99D B0 1A                 bcs   ERRORDMEM                ;ERROR-ABORT REST OF COMMAND
1074 D99F A0 01 00              ldy   #$0001
1075 D9A2 B7 22                 lda   [<DATAPTR],Y             ;GET 2ND DATA BYTE (HI ADDRESS)
1076 D9A4 20 B6 DA              jsr   SDATA                    ; AND S IT
1077 D9A7 B0 10                 bcs   ERRORDMEM                ;ERROR-ABORT REST OF COMMAND
1078 D9A9
1079 D9A9 20 22 DB              jsr   RCVDATA                  ;READ DATA FROM UC
1080 D9AC B0 0B                 bcs   ERRORDMEM                ;ERROR-ABORT REST OF COMMAND
1081 D9AE 87 26                 sta   [<RDMEMPTR]              ;AND STORE IN BUFFER
1082 D9B0 20 CE DA              jsr   IMD
1083 D9B3
1084 D9B3
1085 D9B3              * Clean up stack and finish call
1086 D9B3
1087 D9B3 A2 0A 00              ldx   #$000A                   ;CLEAN OFF 10 INPUT PARAMETERS
1088 D9B6                       entry TONOERR
1089 D9B6              TONOERR                                 ; 
1090 D9B6 4C 9D DB              jmp   NOERR                    ;
1091 D9B9              *
1092 D9B9                       entry ERRORDMEM
1093 D9B9              ERRORDMEM                               ; 
1094 D9B9 20 CE DA              jsr   IMD                      ;CLEAN UP ANY PING STATUS
1095 D9BC A2 0A 00              ldx   #$000A                   ;CLEAN OFF 10 INPUT PARAMETERS
1096 D9BF
1097 D9BF                       entry HARDCALL
1098 D9BF              HARDCALL                                ; 
1099 D9BF A0 10 00              ldy   #HARDERR                 ;ERROR CODE
1100 D9C2 4C A4 DB              jmp   CALL
1101 D9C5
1102 D9C5
1103 D9C5              * FDBTALK
1104 D9C5              * Initiates FDB talk command - which is a ping command
1105 D9C5              * If a command is already ping then flags an error - Busy
1106 D9C5              * Otherwise saves completion vector, sets busy flag and starts command
1107 D9C5              * When sing a ping command, it doesn't wait for the command byte
1108 D9C5              * to be read. The ping flag ensures no overun will occur.
1109 D9C5              * This routine doesn't move the direct page onto the stack, but
1110 D9C5              * instead uses stack relative to get at the data.
1111 D9C5
1112 D9C5                       entry FDBTALK
1113 D9C5              FDBTALK                                 ;       
1114 D9C5
1115 D9C5                       longa on
1116 D9C5                       longi on
1117 D9C5
1118 D9C5 08                    php                            ;SAVE INTERRUPT STATUS
1119 D9C6                       longa off
1120 D9C6 E2 20                 sep   #$20                     ;8-BIT M
1121 D9C8 8B                    phb                            ;SAVE DATA BANK
1122 D9C9 A9 E1                 lda   #DATABNK                 ;CHANGE DATA BANKS
1123 D9CB 48                    pha   
1124 D9CC AB                    plb   
1125 D9CD              *
1126 D9CD A3 0E                 lda   $E,S                     ;GET HI BYTE OF COMPLETION VECTOR
1127 D9CF F0 05                 beq   STRVCTR                  ;IF=0 THEN STORE COMPLETION VECTOR
1128 D9D1              *
1129 D9D1 A0 10 09              ldy   #mytoolnum*256+HARDERR   ;OTHERWISE FLAG ERROR
1130 D9D4 80 23                 bra   CMDP
1131 D9D6              *
1132 D9D6                       entry STRVCTR
1133 D9D6 A9 80        STRVCTR  lda   #PENDBIT                 ;CHECK COMMAND PING FLAG ALREADY SET
1134 D9D8 0C D6 0F              tsb   |FLAGS                   ;THEN SETS FLAGS
1135 D9DB F0 05                 beq   CMDNP                    ;COMMAND WASN'T PING
1136 D9DD              *
1137 D9DD A0 82 09              ldy   #mytoolnum*256+BUSYERR   ;FLAG CMD ALREADY PING - BUSY
1138 D9E0 80 17                 bra   CMDP
1139 D9E2              *
1140 D9E2                       entry CMDNP
1141 D9E2 A3 0B        CMDNP    lda   $B,S                     ;MOVE VECTOR FROM STACK TO MEMORY
1142 D9E4 8D DD 03              sta   |VCTRCPLT+1
1143 D9E7 A3 0C                 lda   $C,S
1144 D9E9 8D DE 03              sta   |VCTRCPLT+2
1145 D9EC A3 0D                 lda   $D,S
1146 D9EE 8D DF 03              sta   |VCTRCPLT+3              ;PROGRAM BANK
1147 D9F1 A3 09                 lda   $9,S                     ;GET COMMAND
1148 D9F3 8D 26 C0              sta   |CMDREG                  ;S IT, BUT DON'T WAIT AROUND
1149 D9F6 A0 00 00              ldy   #$0000                   ;NO ERROR
1150 D9F9              ;
1151 D9F9                       entry CMDP
1152 D9F9              CMDP                                    ; 
1153 D9F9 AB                    plb   
1154 D9FA 28                    plp                            ;RESTORE STACK
1155 D9FB                       longa on
1156 D9FB A3 05                 lda   5,S                      ;MOVE RETURN ADDRESS
1157 D9FD 83 0B                 sta   11,S                     ; AND GET RID OF INPUT STUFF
1158 D9FF A3 03                 lda   3,S
1159 DA01 83 09                 sta   9,S
1160 DA03 A3 01                 lda   1,S
1161 DA05 83 07                 sta   7,S
1162 DA07 68                    pla   
1163 DA08 68                    pla   
1164 DA09 68                    pla   
1165 DA0A 98                    tya                            ;CHECK ERROR CODE
1166 DA0B C9 01 00              cmp   #$0001                   ;SET CARRY IF NOT 0
1167 DA0E 6B                    rtl                            ;RETURN TO GLU
1168 DA0F
1169 DA0F              * FDB Receive
1170 DA0F              * This command is very similar to the FDB TALK command except
1171 DA0F              * it uses 2 bytes of command instead of a single
1172 DA0F
1173 DA0F                       entry FDBRCV
1174 DA0F              FDBRCV                                  ;
1175 DA0F
1176 DA0F                       longa on
1177 DA0F                       longi on
1178 DA0F
1179 DA0F 0B                    phd                            ;SAVE DIRECT PAGE
1180 DA10 08                    php                            ;SAVE INTERRUPT STATUS
1181 DA11 8B                    phb                            ;SAVE DATA BANK
1182 DA12 20 8F DB              jsr   INITOOL                  ;DO INIT STUFF
1183 DA15                       longa off
1184 DA15 1B                    tcs                            ;OPENS UP BUFFER INSIDE STACK
1185 DA16              *
1186 DA16              * Set up Completion Vector
1187 DA16              * Assumes 4-byte address in stack
1188 DA16              * High byte should be zero - lower 3-bytes hold address
1189 DA16              * If ping command flag already set then flag error busy
1190 DA16              *
1191 DA16              *
1192 DA16 A5 25                 lda   <CPLTVCTR+3              ;GET HI BYTE OF COMPLETION VECTOR
1193 DA18 D0 47                 bne   RET1                     ;ERROR IF NOT 0
1194 DA1A              *
1195 DA1A A9 80                 lda   #PENDBIT                 ;CHECK PING BIT
1196 DA1C 0C D6 0F              tsb   |FLAGS
1197 DA1F D0 19                 bne   BUSY                     ;COMMAND ALREADY PING - FLAG BUSY
1198 DA21              *
1199 DA21 A4 22                 ldy   <CPLTVCTR                ;SAVE OFF LOW WORD OF ADDRESS
1200 DA23 8C DD 03              sty   |VCTRCPLT+1
1201 DA26 A5 24                 lda   <CPLTVCTR+2              ;SAVE OFF HI BYTE OF ADDRESS
1202 DA28 8D DF 03              sta   |VCTRCPLT+3
1203 DA2B              *
1204 DA2B 20 50 DA              jsr   SCMD2                    ;S COMMAND BYTE
1205 DA2E B0 13                 bcs   ERROR3
1206 DA30 A5 26                 lda   <FDBCMD                  ;
1207 DA32 20 B6 DA              jsr   SDATA                    ;FOLLOW W/ FDB COMMAND BYTE
1208 DA35 B0 0C                 bcs   ERROR3
1209 DA37 4C 5F D9              jmp   TOOL                     ;CLEAN UP ANY STATUS/RESPONSE LEFTOVERS
1210 DA3A              *  ;RESTORE STACK, ETC.
1211 DA3A              *
1212 DA3A                       entry BUSY
1213 DA3A              BUSY                                    ; 
1214 DA3A A2 08 00              ldx   #$0008                   ;CLEAN 8 BYTES OF STACK
1215 DA3D A0 82 00              ldy   #BUSYERR                 ;FLAG BUSY ERROR
1216 DA40 4C A4 DB              jmp   CALL
1217 DA43              *
1218 DA43                       entry ERROR3
1219 DA43              ERROR3                                  ; 
1220 DA43 A9 80                 lda   #PENDBIT                 ;SINCE ERROR OCCURRED CLEAR PING FLAG
1221 DA45 1C D6 0F              trb   |FLAGS
1222 DA48 4C 67 D9              jmp   ERRORCALL
1223 DA4B
1224 DA4B              * S command
1225 DA4B              * This routine ss a command to uC & cleans data reg. for response
1226 DA4B              * If a command is ping then it sets a flag and reads the response
1227 DA4B              * into a buffer, before executing the immediate command. After
1228 DA4B              * performing the immediate command the response is processed.
1229 DA4B              * After sing the immediate command the Status Reg. is read
1230 DA4B              * till either the command is read by the uC (reg. empty) OR Timeout
1231 DA4B              * The data reg. is then read Immediately to clear out any
1232 DA4B              * ping uC status. This guarantees that the next byte written to the
1233 DA4B              * data reg. will not be status, but data in response to a RCV command.
1234 DA4B              * Valid uC status is stored in Statustmp & processed at  of command
1235 DA4B              * Should always be followed with an IMD call to process any ping
1236 DA4B              * read responses or status.
1237 DA4B              *
1238 DA4B              * 8-bit m, 16-bit x
1239 DA4B              * Error = Carry set
1240 DA4B
1241 DA4B                       entry SCMD
1242 DA4B              SCMD                                    ;
1243 DA4B
1244 DA4B                       longa off
1245 DA4B                       longi on
1246 DA4B
1247 DA4B 20 62 DA              jsr   CHKDOP                   ;IF PING FLAG SET THEN READ RESPONSE
1248 DA4E B0 11                 bcs   RET1
1249 DA50
1250 DA50                       entry SCMD2
1251 DA50              SCMD2                                   ; ;FOR THE CALL FROM FDBRCV
1252 DA50 A5 20                 lda   <UCCMD                   ;GET COMMAND
1253 DA52
1254 DA52                       entry CMDS
1255 DA52              CMDS                                    ;       ;COMMON CMDS ENTRY POINT
1256 DA52 20 B6 DA              jsr   SDATA                    ;AND S IT AND WAIT TIL READ
1257 DA55 B0 0A                 bcs   RET1
1258 DA57 29 10                 and   #DATAFULL/2              ;CHECK IF DATA REG FULL
1259 DA59 F0 06                 beq   RET1                     ;NOT FULL
1260 DA5B AD 26 C0              lda   |DATAREG                 ;FULL - GET uC STATUS
1261 DA5E 0C D7 0F              tsb   |STATUSTMP               ;AND SAVE
1262 DA61              *
1263 DA61                       entry RET1
1264 DA61 60           RET1     rts                            ;CARRY SET = ERR
1265 DA62              *
1266 DA62              * Routine to read response to if ping flag is set.
1267 DA62              * Used by immediate commands to clear out any ping commands
1268 DA62              *
1269 DA62
1270 DA62                       entry CHKDOP
1271 DA62              CHKDOP                                  ;
1272 DA62
1273 DA62                       longa off
1274 DA62                       longi on
1275 DA62
1276 DA62 AD D6 0F              lda   |PENDFLAG                ;CHECK IF COMMAND PING
1277 DA65 10 0A                 bpl   EXECMD                   ;NONE - SO EXECUTE IMMEDIATE COMMAND
1278 DA67 20 36 DB              jsr   READRSPNS                ;GET PING COMMAND RESPONSE DATA
1279 DA6A B0 06                 bcs   GETPATA
1280 DA6C A9 20                 lda   #RSPNSBIT
1281 DA6E 0C D6 0F              tsb   |RSPNSFLAG
1282 DA71                       entry EXECMD
1283 DA71 18           EXECMD   clc   
1284 DA72                       entry GETPATA
1285 DA72 60           GETPATA  rts   
1286 DA73
1287 DA73              * S COMMAND STRING
1288 DA73              * This command ss any bytes after the initial command byte.
1289 DA73              *
1290 DA73              * Errors = Carry set
1291 DA73
1292 DA73                       entry SNDCMDSTR
1293 DA73              SNDCMDSTR                               ; 
1294 DA73
1295 DA73                       longa off
1296 DA73                       longi off
1297 DA73
1298 DA73 E2 30                 sep   #$30
1299 DA75 A5 20                 lda   <UCCMD                   ;GET THE COMMAND FOR ADB
1300 DA77 C9 06                 cmp   #$06                     ;IS IT SET CONFIGURATIONS COMMAND?
1301 DA79 D0 1C                 bne   @1                       ;BRA IF NOT
1302 DA7B AD 8E 01              lda   |KEYUCVER                ;ELSE CHK FOR NEW OR OLD KEYUC
1303 DA7E C9 06                 cmp   #$06                     ;>=$06 THEN NEW KEYUC
1304 DA80 90 15                 bcc   @1                       ;BRA FOR OLD ONE
1305 DA82 A0 02                 ldy   #$02                     ;INDEX TO DELAY/REPEAT BYTE
1306 DA84 B7 22                 lda   [<DATAPTR],Y             ;GET IT
1307 DA86 48                    pha                            ;TEMPORARY SAVE IT
1308 DA87 29 0F                 and   #$0F                     ;MASK OFF FOR REPEAT RATE ONLY
1309 DA89 AA                    tax                            ;AS A NEW INDEX TO NEW TABLE
1310 DA8A 68                    pla   
1311 DA8B 29 F0                 and   #$F0                     ;MAKE REPEAT RATE TO ZERO FIRST
1312 DA8D 48                    pha                            ;SAVE BACK
1313 DA8E BF AC DA FC           lda   >NEWTAB,X                ;GET THE NEW MAPPING VALUE
1314 DA92 03 01                 ora   1,S                      ;GET BACK THE DELAY VALUE IN HIGH NIBBLES
1315 DA94 97 22                 sta   [<DATAPTR],Y             ;STORE BACK TO BE READY TO SEND TO KEYUC
1316 DA96 68                    pla                            ;CLEAN STACK
1317 DA97
1318 DA97              @1        
1319 DA97                       longi on
1320 DA97 C2 10                 rep   #$10                     ;8/16 M/X
1321 DA99
1322 DA99 A0 00 00              ldy   #$0000                   ;SET UP DATA COUNTER
1323 DA9C                       entry DATA
1324 DA9C C4 26        DATA     cpy   <HOWMANY                 ;SEE IF ANY MORE DATA
1325 DA9E B0 0A                 bcs   NOMORE                   ;NO MORE SO GOTO  OF S TOOL
1326 DAA0 B7 22                 lda   [<DATAPTR],Y             ;OTHERWISE GET DATA
1327 DAA2 20 B6 DA              jsr   SDATA
1328 DAA5 B0 04                 bcs   ERRORSND
1329 DAA7 C8                    iny   
1330 DAA8 80 F2                 bra   DATA
1331 DAAA              *
1332 DAAA                       entry NOMORE
1333 DAAA              NOMORE                                  ; 
1334 DAAA 18                    clc   
1335 DAAB                       entry ERRORSND
1336 DAAB 60           ERRORSND rts   
1337 DAAC
1338 DAAC 09           NEWTAB   DC B:$09                       ;FASTEST REPEAT RATE FOR NEW KEYUC
1339 DAAD 08                    DC B:$08
1340 DAAE 07                    DC B:$07
1341 DAAF 06                    DC B:$06
1342 DAB0 05                    DC B:$05
1343 DAB1 04                    DC B:$04
1344 DAB2 03                    DC B:$03
1345 DAB3 02                    DC B:$02
1346 DAB4 01                    DC B:$01
1347 DAB5 00                    DC B:$00                       ;LOWEST "
1348 DAB6
1349 DAB6              * S DATA
1350 DAB6              * S data or command, to the uC using the command reg.
1351 DAB6              * If command reg. is empty ss a data byte, otherwise flags error
1352 DAB6              * If data not read w/ 30 ms. then timeout error
1353 DAB6              * Uses: A (8-BIT)
1354 DAB6              * X (16-BIT)
1355 DAB6              * Input: A=Command
1356 DAB6              * Output: A=KMSTATUS
1357 DAB6              * Errors: CARRY SET
1358 DAB6
1359 DAB6                       entry SDATA
1360 DAB6              SDATA                                   ;
1361 DAB6
1362 DAB6                       longa off
1363 DAB6                       longi on
1364 DAB6
1365 DAB6 AA                    tax                            ;SAVE OFF DATA
1366 DAB7 AD 27 C0              lda   |KMSTATUS                ;GET CMD REG FULL BIT -> LSB
1367 DABA 6A                    ror   a                        ; INTO CARRY
1368 DABB 8A                    txa                            ;GET DATA BACK
1369 DABC B0 0F                 bcs   ERROUT                   ;REG. NOT EMPTY SO FLAG ERROR
1370 DABE              *
1371 DABE 8D 26 C0              sta   |CMDREG                  ;STORE AWAY NEW COMMAND
1372 DAC1 A2 4C 1D              ldx   #7500                    ;TIMEOUT 7500*(2+2+4+2+3)/3 = 30 MS.
1373 DAC4                       entry REGFULL
1374 DAC4 CA           REGFULL  dex                            ;
1375 DAC5 F0 6D                 beq   FDBTIMEOUT
1376 DAC7 AD 27 C0              lda   |KMSTATUS                ;GET CMD REG FULL BIT -> LSB
1377 DACA 6A                    ror   a                        ; INTO CARRY
1378 DACB B0 F7                 bcs   REGFULL                  ;SET IF FULL (NOT READ)
1379 DACD              *  ;CLR IF EMPTY (READ)
1380 DACD              *
1381 DACD                       entry ERROUT
1382 DACD 60           ERROUT   rts                            ;LEAVE W/ A=KMSTATUS CONTENTS
1383 DACE              *
1384 DACE              * Routine to process the  of a command
1385 DACE              * Handles any saved status conditions such as FLUSH, ABORT, DESKTOP
1386 DACE              * Handles the response read from a pending command if it exists
1387 DACE              * Ignores the Desktop Manager Bit ! This occurs because this code
1388 DACE              * would have to emulate all the code the interrupt dispatcher
1389 DACE              * supports before calling the desk manager entry point.
1390 DACE              *
1391 DACE              * 8-Bit m, 16-bit x
1392 DACE
1393 DACE                       entry IMD
1394 DACE              IMD                                     ;
1395 DACE
1396 DACE E2 30                 sep   #$30                     ;8-BIT m,x
1397 DAD0                       longa off
1398 DAD0                       longi off
1399 DAD0
1400 DAD0 A9 50                 lda   #ABORTBIT+FLUSHBIT       ;CLEAR OUT LOW 3 BITS, RESPONSE, SRQ
1401 DAD2 2D D7 0F              and   |STATUSTMP               ; OF STATUS FLAGS
1402 DAD5 8D D7 0F              sta   |STATUSTMP               ;AND UPDATE STATUS FLAGS
1403 DAD8 F0 27                 beq   NOSTSP                   ;NO pending STATUS CONDITIONS
1404 DADA              *
1405 DADA C9 40                 cmp   #ABORTBIT                ;IF ONLY ABORT BIT SET->ABORT CONDITION
1406 DADC D0 0A                 bne   NOTSET
1407 DADE              *
1408 DADE              *  PROCESS ABORT
1409 DADE 8B                    phb                            ;SAVE DATA BANK
1410 DADF A9 00                 lda   #0                       ;SET DATA BANK =0
1411 DAE1 48                    pha   
1412 DAE2 AB                    plb   
1413 DAE3 22 50 00 E1           jsl   IRQ_MICRO                ;PROCESS ABORT - IF RETURNS THEN OK
1414 DAE7 AB                    plb                            ;RESTORE DATA BANK
1415 DAE8              *
1416 DAE8                       entry NOTSET
1417 DAE8 AD D7 0F     NOTSET   lda   |STATUSTMP               ;LOOK FOR FLUSH BUFFER BIT
1418 DAEB 0A                    asl   a
1419 DAEC 0A                    asl   a
1420 DAED F0 12                 beq   NOSTSP                   ;NOT SET
1421 DAEF 90 03                 bcc   NOTABORT                 ;IF ABORT BIT SET THEN CLEAR KEYBOARD
1422 DAF1 8D 10 C0              sta   |KBDSTRB
1423 DAF4                       entry NOTABORT
1424 DAF4              NOTABORT                                ; 
1425 DAF4 A9 00                 lda   #0
1426 DAF6 8D D7 0F              sta   |STATUSTMP               ;CLEAR OUT THE REST OF STATUS BITS
1427 DAF9 8B                    phb   
1428 DAFA 48                    pha                            ;SET DATA BANK TO 0
1429 DAFB AB                    plb   
1430 DAFC 22 4C 00 E1           jsl   IRQ_FLUSH                ;PROCESS FLUSH
1431 DB00 AB                    plb                            ;RESTORE DATA BANK
1432 DB01              *
1433 DB01                       entry NOSTSP
1434 DB01 A9 20        NOSTSP   lda   #RSPNSBIT
1435 DB03 1C D6 0F              trb   |RSPNSFLAG               ;TEST & CLEAR OUT RESPONSE FLAG
1436 DB06 F0 15                 beq   NORSPNSE                 ;IF NO RESPONSE THEN DONE
1437 DB08              *
1438 DB08              * Response was read, from pending command, during immediate command
1439 DB08              * Process data by calling completion vector
1440 DB08              *
1441 DB08 A9 80                 lda   #PENDBIT
1442 DB0A 1C D6 0F              trb   |PENDFLAG                ;CLEAR COMMAND pending FLAG
1443 DB0D F0 0E                 beq   NORSPNSE
1444 DB0F              *
1445 DB0F F4 00 00              pea   $0000                    ;SET UP BUFFER ADDRESS ON STACK
1446 DB12 0B                    phd                            ;BOTTOM OF STACK
1447 DB13
1448 DB13                       longa off
1449 DB13                       longi off
1450 DB13 E2 30                 sep   #$30                     ;8-BIT m,x
1451 DB15
1452 DB15 22 DC 03 E1           jsl   VCTRCPLT                 ;IF RESPONSE READ PREVIOUSLY-PROCESS NOW
1453 DB19                       longa on
1454 DB19                       longi on
1455 DB19 C2 30                 rep   #$30                     ;16-BIT m,x
1456 DB1B 68                    pla                            ;CLEAN OFF BUFFER ADDRESS
1457 DB1C 68                    pla                            ; IN 16-BIT
1458 DB1D              *
1459 DB1D                       entry NORSPNSE
1460 DB1D              NORSPNSE                                ; 
1461 DB1D                       longa off                      ;RESET TO 8-BIT M FROM COMPLETION
1462 DB1D                       longi on                       ;RESET TO 16-BIT X IF SKIPPED COMPLETION
1463 DB1D E2 20                 sep   #$20                     ;8-BIT M, 16-BIT X
1464 DB1F C2 10                 rep   #$10
1465 DB21 60                    rts   
1466 DB22
1467 DB22              * RECEIVE DATA
1468 DB22              * Gets data from the data reg.
1469 DB22              * Assumes the data reg. doesn't contain status (SCMD clears
1470 DB22              * status from data reg. after command is read)
1471 DB22              * Uses A,X
1472 DB22              * 8-bit m, 16-bit x
1473 DB22
1474 DB22                       entry RCVDATA
1475 DB22              RCVDATA                                 ;
1476 DB22
1477 DB22                       longa off
1478 DB22                       longi on
1479 DB22
1480 DB22 18                    clc   
1481 DB23 A2 4C 1D              ldx   #7500                    ;TIMEOUT 7500*(2+2+4+2+3)/3 = 30 MS.
1482 DB26                       entry REGOK
1483 DB26 CA           REGOK    dex   
1484 DB27 F0 0B                 beq   FDBTIMEOUT
1485 DB29 AD 27 C0              lda   |KMSTATUS                ;GET DATA REG FULL BIT -> BIT 5
1486 DB2C 29 20                 and   #DATAFULL                ;AND TEST
1487 DB2E F0 F6                 beq   REGOK                    ;CLR IF EMPTY (READ)
1488 DB30              *  ;SET IF FULL (DON'T READ)
1489 DB30              *
1490 DB30 AD 26 C0              lda   |DATAREG
1491 DB33 60                    rts   
1492 DB34              *
1493 DB34                       entry FDBTIMEOUT
1494 DB34 38           FDBTIMEOUT sec   
1495 DB35 60                    rts   
1496 DB36
1497 DB36
1498 DB36              * Reads a response from a FDB pending command
1499 DB36              * The first response byte has the MSB set (otherwise status) and
1500 DB36              * indicates in the low 3 bits how many bytes will follow.
1501 DB36              * This event must be atomic: Can't be interrupted & must be completed
1502 DB36              * Saves other status bits from response byte -> STATUSTMP (w/MSB clr)
1503 DB36              * Saves the response bytes in RSPNSBUF with the first byte indicating
1504 DB36              * how many bytes are to follow (length). The response bytes are stored
1505 DB36              * backwards in the buffer - the first data byte is at the nth
1506 DB36              * position after the length byte, while the nth byte received is the
1507 DB36              * is the first after the length byte (2nd in the buffer). Actually
1508 DB36              * works out just great since the bytes are transferred from the uC to
1509 DB36              * the system in reverse order: last byte received on FDB is first byte
1510 DB36              * passed from uC to the system. This means that the data is stored
1511 DB36              * in the buffer in the same order as they are received on FDB from
1512 DB36              * the device.
1513 DB36              *
1514 DB36              * ERROR: Carry set
1515 DB36
1516 DB36                       entry READRSPNS
1517 DB36              READRSPNS                               ;
1518 DB36
1519 DB36                       longa off
1520 DB36                       longi on
1521 DB36
1522 DB36 20 22 DB              jsr   RCVDATA                  ;GET DATA BYTE FROM UC
1523 DB39 B0 24                 bcs   ERRRSPNS                 ;TIMEOUT ERROR
1524 DB3B 30 05                 bmi   GOTRSPNS                 ;GOT RESPONSE BYTE
1525 DB3D 0C D7 0F              tsb   |STATUSTMP               ;SAVE UC STATUS BYTE
1526 DB40 80 F4                 bra   READRSPNS                ;GET ANOTHER BYTE
1527 DB42              *
1528 DB42                       entry GOTRSPNS
1529 DB42              GOTRSPNS                                ; ;GOT RESPONSE BYTE
1530 DB42 29 7F                 and   #$7F                     ;CLEAR OUT RESPONSE BIT
1531 DB44 0C D7 0F              tsb   |STATUSTMP               ;SAVE OTHER UC STATUS BITS
1532 DB47                       entry RSPNSINT
1533 DB47 29 07        RSPNSINT and   #$07                     ;GET COUNT FROM LOW 3 BITS
1534 DB49 85 00                 sta   <RSPNSBUF                ;AND SAVE IN RESPONSE BUFFER
1535 DB4B EB                    xba   
1536 DB4C A9 00                 lda   #0                       ;CLEAR OUT HI BYTE
1537 DB4E EB                    xba   
1538 DB4F A8                    tay                            ;COUNT=0 OR N-1 BYTES
1539 DB50 F0 0C                 beq   BYTES                    ;IF 0 THEN NO MORE BYTES TO FOLLOW
1540 DB52 C8                    iny                            ;GET COUNT+1 MORE BYTES
1541 DB53                       entry SOMEMORE
1542 DB53 20 22 DB     SOMEMORE jsr   RCVDATA                  ;GET NEXT BYTE
1543 DB56 B0 07                 bcs   ERRRSPNS                 ;TIMEOUT ERROR
1544 DB58 BB                    tyx                            ;SETUP X FOR DIRECT INDEXED
1545 DB59 95 00                 sta   <RSPNSBUF,X              ;STORE IN BUFFER - START @  &
1546 DB5B 88                    dey                            ; WORK TOWARD BEGINNING OF BUFFER
1547 DB5C D0 F5                 bne   SOMEMORE                 ;STORE MORE
1548 DB5E                       entry BYTES
1549 DB5E              BYTES                                   ; ;CARRY CLEAR IF OK
1550 DB5E 60                    rts   
1551 DB5F                       entry ERRRSPNS
1552 DB5F              ERRRSPNS                                ; ;CARRY SET ON ERROR EXIT
1553 DB5F A9 80                 lda   #PENDBIT                 ;CLEAR OUT pending FLAG ON ERROR
1554 DB61 1C D6 0F              trb   |FLAGS                   ;IF ERROR ENCOUNTERED
1555 DB64 60                    rts   
1556 DB65
1557 DB65
1558 DB65              * RESPONSE INTERRUPT HANDLER
1559 DB65              * This code is the entry point for the response interrupt handler
1560 DB65              * It reads the response, clears the pending flag, then jumps to
1561 DB65              * the completion vector.
1562 DB65              *
1563 DB65              * 8-Bit m, 8-bit x
1564 DB65
1565 DB65                       entry INTRSPNS
1566 DB65              INTRSPNS                                ;
1567 DB65
1568 DB65                       longa off
1569 DB65                       longi off
1570 DB65
1571 DB65 A8                    tay                            ;SAVE RESPONSE BYTE-FROM INTRPT DISPATCH
1572 DB66 0B                    phd                            ;SAVE DIRECT PAGE
1573 DB67 08                    php                            ;SAVE INTERRUPT STATUS
1574 DB68 8B                    phb                            ;SAVE DATA BANK
1575 DB69                       longa on
1576 DB69                       longi on
1577 DB69 C2 30                 rep   #$30                     ;NEED TO BE IN 16-BIT FOR INIT
1578 DB6B 20 8F DB              jsr   INITOOL                  ;DO INIT STUFF
1579 DB6E                       longa off
1580 DB6E 1B                    tcs                            ;OPENS UP BUFFER INSIDE STACK
1581 DB6F A9 80                 lda   #PENDBIT                 ;CHECK AND
1582 DB71 1C D6 0F              trb   |FLAGS                   ;CLEAR OUT pending INTERRUPT
1583 DB74              *  ;IF NOT SET - ERROR DETECTED ON READ
1584 DB74 98                    tya                            ;GET BACK RESPONSE BYTE
1585 DB75 20 47 DB              jsr   RSPNSINT                 ;SAVE RESPONSE BYTE, GET REST -> BUFFER
1586 DB78 90 04                 bcc   GOODRSP                  ;RESPONSE OK
1587 DB7A              *
1588 DB7A A9 00                 lda   #0                       ;FAKE A RESPONSE INSTEAD OF SYSDEATH
1589 DB7C 85 00                 sta   <RSPNSBUF                ;SET # OF BYTES RECEIVED = 0
1590 DB7E              *
1591 DB7E              * Routine to call completion vector to process data
1592 DB7E              * Data stored in RSPNSBUF
1593 DB7E              *
1594 DB7E              * Completion routine should expect:
1595 DB7E              * 8-bit m,x
1596 DB7E              * Pointer to data stored above return address on stack (4-6,S)
1597 DB7E              * RTLs with stack,m,x intact (don't clean up).
1598 DB7E              *
1599 DB7E                       entry GOODRSP
1600 DB7E              GOODRSP                                 ; ;PUSH ADDRESS OF RESPONSE ONTO STACK
1601 DB7E F4 00 00              pea   $0000                    ;HAPPENS TO BE IN BANK 0
1602 DB81 0B                    phd                            ;BOTTOM OF DIRECT PAGE
1603 DB82                       longa on
1604 DB82                       longi on
1605 DB82 E2 30                 sep   #$30                     ;GO IN 8-BIT m,x
1606 DB84 22 DC 03 E1           jsl   VCTRCPLT                 ;COMPLETION VECTOR RETURNS FROM INTERUPT
1607 DB88 C2 30                 rep   #$30                     ;GO IN 16-BIT m,x
1608 DB8A 68                    pla                            ;CLEAN OFF STACK FOR COMPLETION ROUTINE
1609 DB8B 68                    pla   
1610 DB8C 4C CE DB              jmp   CLEAN                    ;USED TO RETURN FROM INTERRUPT
1611 DB8F              *  ;(GOES BACK TO 8-BIT W/ PLP)
1612 DB8F              *
1613 DB8F              * INIT sequence for a typical tool call.
1614 DB8F              * It assumes the following stack structure on entry:
1615 DB8F              *
1616 DB8F              * 11-12 Word: Count of Data bytes (HOWMANY)
1617 DB8F              * D-10 Long: Pointer to Data
1618 DB8F              * B-C Word: Command to uC
1619 DB8F              * 8-A Adrs: Tool Dispatcher Return
1620 DB8F              * 5-7 Adrs: Calling Code Return
1621 DB8F              * 3-4 : Original Direct Page
1622 DB8F              * 2 : Processor Status
1623 DB8F              * 1 : Data Bank
1624 DB8F              * TOS->
1625 DB8F              *
1626 DB8F              * and adds following:
1627 DB8F              *
1628 DB8F              * 2 bytes : Return address from this subroutine
1629 DB8F              * 20 bytes : Buffer for Response
1630 DB8F              *
1631 DB8F              * The direct page is then placed on top of the stack. The stack is
1632 DB8F              * then pushed down one more byte. This allows the beginning of the
1633 DB8F              * direct page to be used as a pointer to data (PHD).
1634 DB8F              * The stack pointer is not actually moved until the routine returns
1635 DB8F              * to the tool call.
1636 DB8F              *
1637 DB8F
1638 DB8F                       entry INITOOL
1639 DB8F              INITOOL                                 ;       
1640 DB8F
1641 DB8F                       longa on                       ;START IN 16-BIT MODE
1642 DB8F                       longi on
1643 DB8F
1644 DB8F 78                    sei                            ;DISABLE INTERRUPTS
1645 DB90 3B                    tsc                            ;MAKE ROOM IN STACK FOR BUFFERS
1646 DB91 38                    sec                            ; (JSR ALREADY TOOK 2 BYTES)
1647 DB92 E9 13 00              sbc   #RSPNSLNG*2-1            ;LEAVE ROOM FOR 2 RESPONSE BUFFERS
1648 DB95 5B                    tcd                            ;PUT DIRECT PAGE ONTO FUTURE STACK
1649 DB96 3A                    dec   a                        ;ADJUST STACK PTR OUTSIDE ZERO PAGE
1650 DB97 20 D9 DB              jsr   DBTOE1                   ;Changes data bank register to $E1
1651 DB9A E2 20                 sep   #$20                     ;8-BIT ACCUMULATOR
1652 DB9C                       longa off
1653 DB9C 60                    rts                            ;MOVE TCS AFTER RETURN TO FIX STACK
1654 DB9D
1655 DB9D              *
1656 DB9D              *  Routine
1657 DB9D              * Used to clean up input parameters off stack,
1658 DB9D              * restore stack pointer, direct page, & data bank.
1659 DB9D              * Sets up carry for error.
1660 DB9D              *
1661 DB9D              * Input: Y -> Error code
1662 DB9D              * X=PARMS -> Parameter Bytes on stack to be cleaned off
1663 DB9D              *
1664 DB9D
1665 DB9D                       entry NOERR
1666 DB9D              NOERR                                   ;       
1667 DB9D
1668 DB9D C2 30                 rep   #$30
1669 DB9F                       longa on
1670 DB9F                       longi on
1671 DB9F
1672 DB9F A0 00 00              ldy   #$0000                   ;INDICATES NO ERROR
1673 DBA2 80 07                 bra   ALL
1674 DBA4
1675 DBA4                       entry CALL
1676 DBA4              CALL                                    ;       
1677 DBA4 C2 30                 rep   #$30                     ;RETURN IN 16-BIT m,x
1678 DBA6 98                    tya   
1679 DBA7 09 00 09              ora   #MYTOOLNUM*256           ;MYTOOL # IN HI BYTE
1680 DBAA A8                    tay   
1681 DBAB
1682 DBAB                       entry ALL
1683 DBAB A5 1E        ALL      lda   <RTLGLU+4                ;MOVE GLU ROUTINE RETURN ADDRESS
1684 DBAD 95 1E                 sta   <RTLGLU+4,X
1685 DBAF A5 1C                 lda   <RTLGLU+2
1686 DBB1 95 1C                 sta   <RTLGLU+2,X              ; AND CALLING RETURN ADDRESS
1687 DBB3 A5 1A                 lda   <RTLGLU+0
1688 DBB5 95 1A                 sta   <RTLGLU+0,X
1689 DBB7
1690 DBB7 86 14                 stx   <PARMS                   ;SAVE # OF PARAMETERS
1691 DBB9 3B                    tsc                            ;MOVE STACK POINTER TO RESTORE STATUS
1692 DBBA 18                    clc   
1693 DBBB 69 16 00              adc   #RSPNSLNG*2+2            ;POINT TO SAVED STATUS (PLB,P,D)
1694 DBBE 1B                    tcs   
1695 DBBF 65 14                 adc   <PARMS                   ;CALCULATE NEW LOCATION OF STACK POINTER
1696 DBC1 69 04 00              adc   #$0004                   ;BY ADDING OFFSET + 4 (SAVED STATUS)
1697 DBC4 AA                    tax                            ;SAVE FOR NOW
1698 DBC5 AB                    plb                            ;RESTORE DATA BANK
1699 DBC6 28                    plp                            ; INTERRUPT STATUS
1700 DBC7 2B                    pld                            ; DIRECT PAGE
1701 DBC8              *
1702 DBC8 98                    tya                            ;SET ERROR CODE
1703 DBC9 C9 01 00              cmp   #$0001                   ;SET CARRY FOR ERROR CODE (CLR ON 0)
1704 DBCC 9A                    txs                            ;MOVE NEW STACK POINTER
1705 DBCD 6B                    rtl                            ;RETURN TO GLU
1706 DBCE
1707 DBCE              * Used to return from an interrupt handler
1708 DBCE              * Enter in 16-bit m,x
1709 DBCE
1710 DBCE                       entry CLEAN
1711 DBCE              CLEAN                                   ;       
1712 DBCE
1713 DBCE                       longa on                       ;NEEDED FOR STACK CALCULATION
1714 DBCE                       longi on
1715 DBCE
1716 DBCE 3B                    tsc                            ;GET STACK PTR
1717 DBCF 18                    clc   
1718 DBD0 69 16 00              adc   #RSPNSLNG*2+2            ;POINT TO SAVED STATUS (PLB,P,D)
1719 DBD3 1B                    tcs                            ;RESTORE STACK POINTER
1720 DBD4 AB                    plb                            ;RESTORE DATA BANK
1721 DBD5 28                    plp                            ; STATUS (8-BIT m,x)
1722 DBD6 2B                    pld                            ; DIRECT PAGE
1723 DBD7 18                    clc                            ;HANDLED INTERRUPT - NOTIFY DISPATCHER
1724 DBD8 6B                    rtl                            ;RETURN TO INTERRUPT DISPATCHER
1725 DBD9
1726 DBD9              *
1727 DBD9              * Set data bank to $e1
1728 DBD9              *
1729 DBD9                       entry DBTOE1
1730 DBD9              DBTOE1                                  ;
1731 DBD9 F4 E1 E1              pea   $E1E1
1732 DBDC AB                    plb   
1733 DBDD AB                    plb   
1734 DBDE 60                    rts   
1735 DBDF
1736 DBDF
1737 DBDF                       ENDP 
1738 DBDF
1739 DBDF
1740 DBDF                       end   
